<?php

namespace App\Controllers;

use App\Models\StransportModel;
use App\Models\MappingModel;
use App\Controllers\BaseController;

class Stransport extends BaseController
{
    public function __construct(){
		
		$this->sistem = new StransportModel();
		$this->map = new MappingModel();
		
	}
    public function index()
    {
        $data =[
			'title'=>'Sistem Transport',
			'sistem'=>$this->sistem->findAll(),
			'map'=>$this->map->findAll(),
			'validation' => \Config\Services::validation()
		];

        return view('sistem-transport/index',$data);
    }

    public function save(){
		if (!$this->validate([
			'sistem_transport'=>[
				'rules'=>'is_unique[p_transport.sistem_transport]',
				'errors'=>[
					'is_unique'=>'{field}sudah terdaftar.'
				]
			],

		])){
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}
		$this->sistem->save([
			'sistem_transport'=> $this->request->getVar('sistem')
		]);
		return redirect()->to(site_url("sistem"));
	}

	public function update($id){
		if (!$this->validate([
			'sistem_transport'=>[
				'rules'=>'is_unique[p_transport.sistem_transport]',
				'errors'=>[
					'is_unique'=>'{field}sudah terdaftar.'
				]
			],

		])){
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}
		$this->sistem->update($id,[
			'sistem_transport'=> $this->request->getVar('sistem')
		]);
		return redirect()->to(site_url("sistem"));
	}
	public function delete($tamp){
		$this->sistem->delete($tamp);
		$this->map->where('sistem_transport',$tamp)->delete();
		return redirect()->to('sistem');	
	}

}
