<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\LinkModel;
use App\Models\MappingModel;
use App\Models\StransportModel;
use App\Models\DatekModel;
use App\Models\HostnameModel;
class Mapping extends BaseController
{
        
	public function __construct(){
		$this->link = new LinkModel();
		$this->host = new HostnameModel();
		$this->map = new MappingModel();
		$this->sistem = new StransportModel();
		$this->datek = new DatekModel();
	}

    public function index()
    {
        $data =[
			'title'=>'Mapping',
			'mapping'=>$this->map->orderBy('link_id','ASC')->getMap(),
			'sistem'=>$this->sistem->findAll(),
			'datek'=>$this->datek->findAll(),
			'host'=>$this->host->findAll(),
			'link'=>$this->link->findAll()
		];
		return view('mapping/index',$data);
    }


        public function save(){
        	$link = $this->request->getVar('link');
        	$port = $this->request->getVar('port');
        	$portb = $this->request->getVar('portb');
        	$format = $this->request->getVar('format');
        	$nea= $this->request->getVar('nea');
        	$neb = $this->request->getVar('neb');
        	$tamp=0;
			if (!$this->validate([
				'description'=>[
					'rules'=>'is_unique[mapping.description]',
					'errors'=>[
						'is_unique'=>'{field}sudah terdaftar.'
					]
				],

			])){
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}

		if($tamp==1 and $link=='null' and $port=='null' and $portb=='null' and $format=='null' and $nea == $neb){
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}
		$this->map->save([
			'link_id'=> $this->request->getVar('link'),
			'description'=> $this->request->getVar('description'),
			'ne_a'=> $this->request->getVar('nea'),
			'port_a'=> $this->request->getVar('port'),
			'freq'=> $this->request->getVar('freq'),
			'modul'=> $this->request->getVar('modul'),
			'bandwidth'=> $this->request->getVar('bandwidth'),
			'sistem_transport'=> $this->request->getVar('sistem'),
			'ne_b'=> $this->request->getVar('neb'),
			'port_b'=> $this->request->getVar('portb')
			
		]);
		return redirect()->to(site_url("mapping"));
	}

	public function update($id){
        	$link = $this->request->getVar('link');
        	$port = $this->request->getVar('port');
        	$portb = $this->request->getVar('portb');
        	$format = $this->request->getVar('format');
        	$nea= $this->request->getVar('nea');
        	$neb = $this->request->getVar('neb');
        	$tamp=0;


		if($tamp==1 and $link=='null' and $port=='null' and $portb=='null' and $format=='null' and $nea == $neb){
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}
		$this->map->update($id,[
			'link_id'=> $this->request->getVar('link'),
			'description'=> $this->request->getVar('description'),
			'ne_a'=> $this->request->getVar('nea'),
			'port_a'=> $this->request->getVar('port'),
			'freq'=> $this->request->getVar('freq'),
			'modul'=> $this->request->getVar('modul'),
			'bandwidth'=> $this->request->getVar('bandwidth'),
			'sistem_transport'=> $this->request->getVar('sistem'),
			'ne_b'=> $this->request->getVar('neb'),
			'port_b'=> $this->request->getVar('portb')
			
		]);
		return redirect()->to(site_url("mapping"));
	}
	public function delete($tamp){
		$this->map->delete($tamp);
		return redirect()->to('sistem');	
	}
    }