<?php

namespace App\Controllers;
use App\Models\LinkModel;
use App\Models\HostnameModel;
use App\Models\MappingModel;
use App\Controllers\BaseController;

class Link extends BaseController
{
	public function __construct(){
		
		$this->link = new LinkModel();
		$this->hostname = new HostnameModel();
		$this->map = new MappingModel();
		
	}

    public function index()
    {
    	$data =[
			'title'=>'Link',
			'link'=>$this->link->getlink(),
			'tes'=>$this->link->findAll(),
			'hostname'=>$this->hostname->gethost(),
			'data'=>$this->map->findAll(),
			'validation' => \Config\Services::validation()
		];
		return view('link/index',$data);
    }

        public function error()
    {

        return view('link/error');
    }

    public function save(){
    	$host1 = $this->request->getVar('host1');
		$host2 = $this->request->getVar('host2');
		$tamp=1;
		if ($host2 === $host1) {
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}

		if (!$this->validate([
			'link'=>[
				'rules'=>'is_unique[link.link]',
				'errors'=>[
					'is_unique'=>'{field}sudah terdaftar.'
				]
			],

		])){
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}elseif ($tamp==0 and $host2=='null' and $host1=='null') {
			return redirect()->to(site_url("error"));
		}
		$this->link->save([
			'link'=> $this->request->getVar('link'),
			'hostname_a'=> $this->request->getVar('host1'),
			'port_a'=> $this->request->getVar('port'),
			'hostname_b'=> $this->request->getVar('host2'),
			'port_b'=> $this->request->getVar('portB')
		]);
		return redirect()->to(site_url("link"));
	}

	public function update($id){
    	$host1 = $this->request->getVar('host1');
		$host2 = $this->request->getVar('host2');
		$tamp=1;
		if ($host2 === $host1) {
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}

		if ($tamp==0 and $host2=='null' and $host1=='null') {
			return redirect()->to(site_url("error"));
		}

		$this->link->update($id,[
			'link'=> $this->request->getVar('link'),
			'hostname_a'=> $this->request->getVar('host1'),
			'port_a'=> $this->request->getVar('port'),
			'hostname_b'=> $this->request->getVar('host2'),
			'port_b'=> $this->request->getVar('portB')
		]);
		return redirect()->to(site_url("link"));
	}
	public function delete($tamp){
		$this->link->delete($tamp);
		$this->map->where('link_id',$tamp)->delete();
		return redirect()->to('link');	
	}
}
