<?php

namespace App\Controllers;

use App\Models\HostnameModel;
use App\Models\LinkModel;
use App\Controllers\BaseController;

class Hostname extends BaseController
{

	public function __construct(){
		
		$this->hostname = new HostnameModel();
		$this->link = new LinkModel();
		
	}
    public function index()
    {

        $data =[
			'title'=>'Hostname',
			'hostname'=>$this->hostname->findAll(),
			'link'=>$this->link->findAll(),
			'validation' => \Config\Services::validation()
		];

        return view('hostname/index',$data);
    }

    public function save(){
		if (!$this->validate([
			'name'=>[
				'rules'=>'is_unique[hostname.name]',
				'errors'=>[
					'is_unique'=>'{field}sudah terdaftar.'
				]
			],

		])){
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}
		$this->hostname->save([
			'name'=> $this->request->getVar('hostname'),
			'tamp'=> $this->request->getVar('hostname')
		]);
		return redirect()->to(site_url("hostname"));
	}
	public function update($id){
		if (!$this->validate([
			'name'=>[
				'rules'=>'is_unique[hostname.name]',
				'errors'=>[
					'is_unique'=>'{field}sudah terdaftar.'
				]
			],

		])){
			$validation = \Config\Services::validation();
			return redirect()->to(site_url("error"))->withInput()->with('validation',$validation);
		}
			
				$this->hostname->update($id,[
					'name'=> $this->request->getVar('hostname'),
					'tamp'=> $this->request->getVar('hostname')
				]);
				return redirect()->to('hostname');		
	}

	public function delete($tamp){
		$this->hostname->delete($tamp);
		return redirect()->to('hostname');	
	}
}
